/* global wc, wp */
(() => {
    const settings = (window.wc && wc.wcSettings && wc.wcSettings.getSetting)
        ? wc.wcSettings.getSetting('paygenius-redirect_data', {})
        : {};

    const label = settings?.title || 'PayGenius';

    const Content = () =>
        wp.element.createElement(
            'div',
            { className: 'wc-payment-method__paygenius-description' },
            settings?.description || ''
        );

    const registry =
        (window.wc && wc.wcBlocksRegistry) ||
        (window.wc && wc.blocksRegistry);

    if (!registry || typeof registry.registerPaymentMethod !== 'function') {
        console.error('[PayGenius] WooCommerce Blocks registry not found.');
        return;
    }

    registry.registerPaymentMethod({
        name: 'paygenius-redirect', 
        label,
        ariaLabel: label,
        content: wp.element.createElement(Content),
        edit: wp.element.createElement(Content),
        canMakePayment: () => true,
        supports: settings?.supports || { features: ['products'] },
        placeOrderButtonLabel: settings?.placeOrderButtonLabel,
    });
})();
